# دليل رفع المشروع على VPS/cPanel

## المتطلبات الأساسية

1. **VPS أو استضافة cPanel مع دعم Node.js** (الإصدار 18 أو أحدث)
2. **قاعدة بيانات MySQL** (يجب إنشاؤها من cPanel)
3. **SSH Access** (للوصول إلى السيرفر)
4. **Domain مربوط بالاستضافة**

---

## الخطوة 1: إعداد قاعدة البيانات MySQL على cPanel

### 1.1 إنشاء قاعدة البيانات
1. ادخل على **cPanel**
2. اذهب إلى **MySQL Databases**
3. أنشئ قاعدة بيانات جديدة، مثلاً: `lawyermbs_db`
4. أنشئ مستخدم جديد، مثلاً: `lawyermbs_user`
5. اختر كلمة مرور قوية
6. أضف المستخدم إلى قاعدة البيانات مع **All Privileges**

### 1.2 احفظ بيانات الاتصال
```
Database Name: lawyermbs_db
Database User: lawyermbs_user
Database Password: [كلمة المرور القوية]
Database Host: localhost (أو عنوان IP السيرفر)
```

---

## الخطوة 2: تحديث إعدادات المشروع للإنتاج

### 2.1 تحديث Prisma Schema
افتح ملف `prisma/schema.prisma` وغيّر من SQLite إلى MySQL:

```prisma
datasource db {
  provider = "mysql"
  url      = env("DATABASE_URL")
}
```

### 2.2 إنشاء ملف .env للإنتاج
على السيرفر، أنشئ ملف `.env` بالمحتوى التالي:

```env
# قاعدة البيانات
DATABASE_URL="mysql://lawyermbs_user:YOUR_PASSWORD@localhost:3306/lawyermbs_db"

# NextAuth
NEXTAUTH_SECRET="YOUR_STRONG_SECRET_KEY_HERE_CHANGE_THIS"
NEXTAUTH_URL="https://yourdomain.com"

# Node Environment
NODE_ENV="production"
```

**مهم جداً:**
- استبدل `YOUR_PASSWORD` بكلمة مرور قاعدة البيانات
- استبدل `YOUR_STRONG_SECRET_KEY_HERE_CHANGE_THIS` بمفتاح سري قوي (يمكنك توليده من: https://generate-secret.vercel.app/32)
- استبدل `yourdomain.com` بدومينك الفعلي

---

## الخطوة 3: رفع المشروع على السيرفر

### 3.1 ضغط المشروع
على جهازك المحلي:

1. احذف المجلدات التالية (لن تحتاجها):
   - `node_modules`
   - `.next`
   - `prisma/dev.db`
   - `prisma/dev.db-journal`

2. اضغط المشروع كاملاً في ملف ZIP

### 3.2 رفع الملفات عبر cPanel
1. ادخل على **cPanel**
2. اذهب إلى **File Manager**
3. اذهب إلى مجلد `public_html` (أو المجلد الخاص بدومينك)
4. ارفع ملف ZIP
5. استخرج الملفات (Extract)

---

## الخطوة 4: تثبيت المشروع عبر SSH

### 4.1 الاتصال بالسيرفر
افتح Terminal (أو PuTTY على Windows) واتصل بالسيرفر:

```bash
ssh username@your-server-ip
```

### 4.2 الانتقال لمجلد المشروع
```bash
cd ~/public_html
# أو
cd ~/domains/yourdomain.com/public_html
```

### 4.3 تثبيت Dependencies
```bash
npm install
```

### 4.4 إنشاء ملف .env
```bash
nano .env
```

الصق المحتوى من الخطوة 2.2، ثم احفظ:
- اضغط `Ctrl + X`
- اضغط `Y`
- اضغط `Enter`

### 4.5 تطبيق Migrations على قاعدة البيانات
```bash
npx prisma migrate deploy
```

### 4.6 توليد Prisma Client
```bash
npx prisma generate
```

### 4.7 إنشاء مستخدم Admin (مرة واحدة فقط)
```bash
npm run db:seed
```

**ملاحظة:** هذا سينشئ مستخدم:
- Username: `admin`
- Password: `wq90wq90WW`

### 4.8 بناء المشروع للإنتاج
```bash
npm run build
```

---

## الخطوة 5: تشغيل المشروع

### 5.1 تشغيل بشكل مؤقت (للاختبار)
```bash
npm start
```

المشروع سيعمل على المنفذ 3000 افتراضياً.

### 5.2 تشغيل دائم باستخدام PM2

#### تثبيت PM2
```bash
npm install -g pm2
```

#### تشغيل المشروع
```bash
pm2 start npm --name "lawyermbs" -- start
```

#### حفظ الإعدادات للتشغيل التلقائي عند إعادة التشغيل
```bash
pm2 save
pm2 startup
```

#### أوامر مفيدة لـ PM2
```bash
# عرض حالة التطبيقات
pm2 list

# عرض logs
pm2 logs lawyermbs

# إعادة تشغيل
pm2 restart lawyermbs

# إيقاف
pm2 stop lawyermbs

# حذف
pm2 delete lawyermbs
```

---

## الخطوة 6: إعداد Reverse Proxy (Nginx أو Apache)

### إذا كنت تستخدم Nginx:

أنشئ ملف configuration:
```bash
sudo nano /etc/nginx/sites-available/lawyermbs
```

أضف:
```nginx
server {
    listen 80;
    server_name yourdomain.com www.yourdomain.com;

    location / {
        proxy_pass http://localhost:3000;
        proxy_http_version 1.1;
        proxy_set_header Upgrade $http_upgrade;
        proxy_set_header Connection 'upgrade';
        proxy_set_header Host $host;
        proxy_cache_bypass $http_upgrade;
        proxy_set_header X-Real-IP $remote_addr;
        proxy_set_header X-Forwarded-For $proxy_add_x_forwarded_for;
        proxy_set_header X-Forwarded-Proto $scheme;
    }
}
```

فعّل الموقع:
```bash
sudo ln -s /etc/nginx/sites-available/lawyermbs /etc/nginx/sites-enabled/
sudo nginx -t
sudo systemctl reload nginx
```

### إذا كنت تستخدم Apache (cPanel):

من cPanel، اذهب إلى **Setup Node.js App**:
1. اضغط **Create Application**
2. اختر Node.js Version: 18 أو أحدث
3. Application Mode: **Production**
4. Application Root: مسار مجلد المشروع
5. Application URL: دومينك
6. Application Startup File: `server.js` أو اترك فارغاً
7. اضغط **Create**

---

## الخطوة 7: تفعيل SSL (HTTPS)

### باستخدام Let's Encrypt (مجاني)

من cPanel:
1. اذهب إلى **SSL/TLS Status**
2. اختر دومينك
3. اضغط **Run AutoSSL**

أو عبر SSH:
```bash
sudo certbot --nginx -d yourdomain.com -d www.yourdomain.com
```

---

## الخطوة 8: التحقق من عمل الموقع

1. افتح المتصفح واذهب إلى: `https://yourdomain.com`
2. جرّب تسجيل الدخول:
   - Username: `admin`
   - Password: `wq90wq90WW`
3. اختبر جميع الصفحات والوظائف

---

## إعدادات الأمان المهمة

### 1. تأمين ملف .env
```bash
chmod 600 .env
```

### 2. إخفاء معلومات السيرفر
في `next.config.ts`، تأكد من:
```typescript
poweredByHeader: false
```

### 3. تحديث كلمة المرور الافتراضية
بعد أول تسجيل دخول، غيّر كلمة مرور Admin من لوحة التحكم.

### 4. Firewall
تأكد من فتح المنافذ المطلوبة فقط:
- 80 (HTTP)
- 443 (HTTPS)
- 22 (SSH)

---

## التحديثات المستقبلية

عند تحديث المشروع:

```bash
# 1. اسحب التحديثات
git pull origin main

# 2. ثبّت Dependencies الجديدة
npm install

# 3. طبّق Migrations
npx prisma migrate deploy

# 4. أعد البناء
npm run build

# 5. أعد تشغيل التطبيق
pm2 restart lawyermbs
```

---

## استكشاف الأخطاء

### المشروع لا يعمل؟
```bash
# تحقق من logs
pm2 logs lawyermbs

# تحقق من حالة التطبيق
pm2 list

# تحقق من المنفذ
netstat -tulpn | grep 3000
```

### خطأ في قاعدة البيانات؟
```bash
# تحقق من الاتصال
npx prisma db pull

# أعد تطبيق Migrations
npx prisma migrate reset --force
npx prisma migrate deploy
```

### صفحة 502 Bad Gateway؟
- تأكد من أن التطبيق يعمل: `pm2 list`
- تأكد من إعدادات Nginx/Apache
- تحقق من logs: `pm2 logs`

---

## الدعم

إذا واجهت أي مشكلة:
1. تحقق من logs: `pm2 logs lawyermbs`
2. تحقق من ملف `.env`
3. تأكد من أن قاعدة البيانات تعمل
4. تحقق من إعدادات Firewall

---

## ملاحظات مهمة

1. **لا تشارك ملف .env** أبداً
2. **احتفظ بنسخة احتياطية** من قاعدة البيانات بانتظام
3. **راقب logs** للتأكد من عدم وجود أخطاء
4. **حدّث Dependencies** بانتظام للأمان

---

✅ **تم! موقعك الآن يعمل على الإنتاج** 🚀
