import { NextResponse } from 'next/server'
import { prisma } from '@/lib/prisma'

export async function GET() {
  try {
    const accreditations = await prisma.accreditation.findMany({
      orderBy: { order: 'asc' }
    })

    return NextResponse.json(accreditations)
  } catch (error) {
    return NextResponse.json({ error: 'Failed to fetch' }, { status: 500 })
  }
}
