import { NextResponse } from 'next/server'
import { prisma } from '@/lib/prisma'

export async function POST(request: Request) {
  try {
    const body = await request.json()
    const { name, phone, email, service, message } = body

    const contactMessage = await prisma.contactMessage.create({
      data: {
        name,
        phone,
        email,
        service,
        message,
      },
    })

    return NextResponse.json(contactMessage, { status: 201 })
  } catch (error) {
    return NextResponse.json({ error: 'Failed to create message' }, { status: 500 })
  }
}
