import { NextResponse } from 'next/server'
import { prisma } from '@/lib/prisma'

export async function GET() {
  try {
    const contents = await prisma.content.findMany({
      where: {
        key: { in: ['about_text', 'vision', 'mission', 'values', 'values_image'] }
      }
    })

    const contentMap: any = {
      aboutAr: '',
      aboutEn: '',
      visionAr: '',
      visionEn: '',
      missionAr: '',
      missionEn: '',
      valuesAr: '',
      valuesEn: '',
      valuesImage: '',
    }

    contents.forEach((item: any) => {
      if (item.key === 'about_text') {
        contentMap.aboutAr = item.valueAr || ''
        contentMap.aboutEn = item.valueEn || ''
      }
      if (item.key === 'vision') {
        contentMap.visionAr = item.valueAr || ''
        contentMap.visionEn = item.valueEn || ''
      }
      if (item.key === 'mission') {
        contentMap.missionAr = item.valueAr || ''
        contentMap.missionEn = item.valueEn || ''
      }
      if (item.key === 'values') {
        contentMap.valuesAr = item.valueAr || ''
        contentMap.valuesEn = item.valueEn || ''
      }
      if (item.key === 'values_image') {
        contentMap.valuesImage = item.valueAr || ''
      }
    })

    return NextResponse.json(contentMap)
  } catch (error) {
    return NextResponse.json({ error: 'Failed to fetch' }, { status: 500 })
  }
}
