import { NextResponse } from 'next/server'
import { prisma } from '@/lib/prisma'

export async function GET() {
  try {
    const contents = await prisma.content.findMany({
      where: {
        key: { in: ['transparency', 'commitment', 'innovation'] }
      }
    })

    const contentMap: any = {
      transparencyAr: '',
      transparencyEn: '',
      commitmentAr: '',
      commitmentEn: '',
      innovationAr: '',
      innovationEn: '',
    }

    contents.forEach((item: any) => {
      if (item.key === 'transparency') {
        contentMap.transparencyAr = item.valueAr || ''
        contentMap.transparencyEn = item.valueEn || ''
      }
      if (item.key === 'commitment') {
        contentMap.commitmentAr = item.valueAr || ''
        contentMap.commitmentEn = item.valueEn || ''
      }
      if (item.key === 'innovation') {
        contentMap.innovationAr = item.valueAr || ''
        contentMap.innovationEn = item.valueEn || ''
      }
    })

    return NextResponse.json(contentMap)
  } catch (error) {
    return NextResponse.json({ error: 'Failed to fetch' }, { status: 500 })
  }
}
