import { NextResponse } from 'next/server'
import { getServerSession } from 'next-auth'
import { authOptions } from '@/lib/auth'
import { prisma } from '@/lib/prisma'

export async function GET() {
  try {
    const session = await getServerSession(authOptions)
    if (!session) {
      return NextResponse.json({ error: 'Unauthorized' }, { status: 401 })
    }

    const settings = await prisma.content.findMany({
      where: {
        key: {
          in: ['logo_url', 'site_title', 'site_description', 'phone', 'email', 'address', 'working_hours', 'twitter_url', 'instagram_url', 'linkedin_url']
        }
      }
    })

    const settingsMap: any = {
      logoUrl: '',
      siteTitleAr: '',
      siteTitleEn: '',
      siteDescriptionAr: '',
      siteDescriptionEn: '',
      phone: '',
      email: '',
      address: '',
      workingHours: '',
      twitterUrl: '',
      instagramUrl: '',
      linkedinUrl: '',
    }

    settings.forEach((item: any) => {
      if (item.key === 'logo_url') settingsMap.logoUrl = item.valueAr || ''
      if (item.key === 'site_title') {
        settingsMap.siteTitleAr = item.valueAr || ''
        settingsMap.siteTitleEn = item.valueEn || ''
      }
      if (item.key === 'site_description') {
        settingsMap.siteDescriptionAr = item.valueAr || ''
        settingsMap.siteDescriptionEn = item.valueEn || ''
      }
      if (item.key === 'phone') settingsMap.phone = item.valueAr || ''
      if (item.key === 'email') settingsMap.email = item.valueAr || ''
      if (item.key === 'address') settingsMap.address = item.valueAr || ''
      if (item.key === 'working_hours') settingsMap.workingHours = item.valueAr || ''
      if (item.key === 'twitter_url') settingsMap.twitterUrl = item.valueAr || ''
      if (item.key === 'instagram_url') settingsMap.instagramUrl = item.valueAr || ''
      if (item.key === 'linkedin_url') settingsMap.linkedinUrl = item.valueAr || ''
    })

    return NextResponse.json(settingsMap)
  } catch (error) {
    return NextResponse.json({ error: 'Failed to fetch' }, { status: 500 })
  }
}

export async function POST(request: Request) {
  try {
    const session = await getServerSession(authOptions)
    if (!session) {
      return NextResponse.json({ error: 'Unauthorized' }, { status: 401 })
    }

    const body = await request.json()

    await prisma.content.upsert({
      where: { key: 'logo_url' },
      update: { valueAr: body.logoUrl, valueEn: body.logoUrl },
      create: { key: 'logo_url', valueAr: body.logoUrl, valueEn: body.logoUrl }
    })

    await prisma.content.upsert({
      where: { key: 'site_title' },
      update: { valueAr: body.siteTitleAr, valueEn: body.siteTitleEn },
      create: { key: 'site_title', valueAr: body.siteTitleAr, valueEn: body.siteTitleEn }
    })

    await prisma.content.upsert({
      where: { key: 'site_description' },
      update: { valueAr: body.siteDescriptionAr, valueEn: body.siteDescriptionEn },
      create: { key: 'site_description', valueAr: body.siteDescriptionAr, valueEn: body.siteDescriptionEn }
    })

    await prisma.content.upsert({
      where: { key: 'phone' },
      update: { valueAr: body.phone, valueEn: body.phone },
      create: { key: 'phone', valueAr: body.phone, valueEn: body.phone }
    })

    await prisma.content.upsert({
      where: { key: 'email' },
      update: { valueAr: body.email, valueEn: body.email },
      create: { key: 'email', valueAr: body.email, valueEn: body.email }
    })

    await prisma.content.upsert({
      where: { key: 'address' },
      update: { valueAr: body.address, valueEn: body.address },
      create: { key: 'address', valueAr: body.address, valueEn: body.address }
    })

    await prisma.content.upsert({
      where: { key: 'working_hours' },
      update: { valueAr: body.workingHours, valueEn: body.workingHours },
      create: { key: 'working_hours', valueAr: body.workingHours, valueEn: body.workingHours }
    })

    await prisma.content.upsert({
      where: { key: 'twitter_url' },
      update: { valueAr: body.twitterUrl, valueEn: body.twitterUrl },
      create: { key: 'twitter_url', valueAr: body.twitterUrl, valueEn: body.twitterUrl }
    })

    await prisma.content.upsert({
      where: { key: 'instagram_url' },
      update: { valueAr: body.instagramUrl, valueEn: body.instagramUrl },
      create: { key: 'instagram_url', valueAr: body.instagramUrl, valueEn: body.instagramUrl }
    })

    await prisma.content.upsert({
      where: { key: 'linkedin_url' },
      update: { valueAr: body.linkedinUrl, valueEn: body.linkedinUrl },
      create: { key: 'linkedin_url', valueAr: body.linkedinUrl, valueEn: body.linkedinUrl }
    })

    return NextResponse.json({ success: true })
  } catch (error) {
    return NextResponse.json({ error: 'Failed to save' }, { status: 500 })
  }
}
