import { NextResponse } from 'next/server'
import { prisma } from '@/lib/prisma'

export async function GET() {
  try {
    const settings = await prisma.content.findMany({
      where: {
        key: {
          in: ['logo_url', 'site_title', 'phone', 'email', 'address']
        }
      }
    })

    const settingsMap: any = {
      logoUrl: '',
      siteTitleAr: '',
      siteTitleEn: '',
      phone: '',
      email: '',
      address: '',
    }

    settings.forEach((item: any) => {
      if (item.key === 'logo_url') settingsMap.logoUrl = item.valueAr || ''
      if (item.key === 'site_title') {
        settingsMap.siteTitleAr = item.valueAr || ''
        settingsMap.siteTitleEn = item.valueEn || ''
      }
      if (item.key === 'phone') settingsMap.phone = item.valueAr || ''
      if (item.key === 'email') settingsMap.email = item.valueAr || ''
      if (item.key === 'address') settingsMap.address = item.valueAr || ''
    })

    return NextResponse.json(settingsMap)
  } catch (error) {
    return NextResponse.json({ error: 'Failed to fetch' }, { status: 500 })
  }
}
