'use client'

import Link from 'next/link'
import { usePathname } from 'next/navigation'
import { signOut } from 'next-auth/react'
import { 
  LayoutDashboard, 
  FileText, 
  Briefcase, 
  Award, 
  Lightbulb, 
  Users, 
  Building2, 
  Settings, 
  Mail,
  LogOut 
} from 'lucide-react'

const menuItems = [
  { href: '/ar/dashboard', icon: LayoutDashboard, label: 'الرئيسية' },
  { href: '/ar/dashboard/content', icon: FileText, label: 'المحتوى' },
  { href: '/ar/dashboard/services', icon: Briefcase, label: 'الخدمات القانونية' },
  { href: '/ar/dashboard/accreditations', icon: Award, label: 'الاعتمادات' },
  { href: '/ar/dashboard/principles', icon: Lightbulb, label: 'المبادئ' },
  { href: '/ar/dashboard/team', icon: Users, label: 'أعضاء الفريق' },
  { href: '/ar/dashboard/clients', icon: Building2, label: 'العملاء' },
  { href: '/ar/dashboard/messages', icon: Mail, label: 'الرسائل' },
  { href: '/ar/dashboard/settings', icon: Settings, label: 'الإعدادات' },
]

export default function DashboardSidebar() {
  const pathname = usePathname()

  return (
    <aside className="w-64 bg-[#33335E] text-white min-h-screen p-6">
      <div className="mb-8">
        <h2 className="text-2xl font-bold">لوحة التحكم</h2>
        <p className="text-sm text-gray-300 mt-1">مكتب المحاماة</p>
      </div>

      <nav className="space-y-2">
        {menuItems.map((item) => {
          const Icon = item.icon
          const isActive = pathname === item.href
          
          return (
            <Link
              key={item.href}
              href={item.href}
              className={`flex items-center gap-3 px-4 py-3 rounded-lg transition-colors ${
                isActive
                  ? 'bg-white text-[#33335E]'
                  : 'hover:bg-white/10'
              }`}
            >
              <Icon className="w-5 h-5" />
              <span>{item.label}</span>
            </Link>
          )
        })}
      </nav>

      <button
        onClick={() => signOut({ callbackUrl: '/ar/login' })}
        className="flex items-center gap-3 px-4 py-3 rounded-lg hover:bg-white/10 transition-colors w-full mt-8"
      >
        <LogOut className="w-5 h-5" />
        <span>تسجيل الخروج</span>
      </button>
    </aside>
  )
}
