'use client'

import Link from 'next/link'
import { useTranslations, useLocale } from 'next-intl'
import { Phone, Mail, MapPin, Clock, Twitter, Instagram, Linkedin } from 'lucide-react'

export default function Footer() {
  const t = useTranslations('footer')
  const locale = useLocale()

  return (
    <footer className="bg-[#33335E] text-white">
      <div className="container mx-auto px-4 py-12">
        <div className="grid grid-cols-1 md:grid-cols-4 gap-8">
          {/* About */}
          <div>
            <h3 className="text-xl font-bold mb-4 text-white">{t('about')}</h3>
            <p className="text-gray-300 text-sm leading-relaxed">
              {t('aboutText')}
            </p>
          </div>

          {/* Contact */}
          <div>
            <h3 className="text-xl font-bold mb-4 text-white">{t('contact')}</h3>
            <div className="space-y-3">
              <div className="flex items-start gap-3">
                <Clock className="w-5 h-5 text-white mt-1 flex-shrink-0" />
                <div className="text-sm">
                  <p className="text-gray-300">{t('workingHours')}</p>
                  <p className="text-white font-medium">{t('time')}</p>
                </div>
              </div>
              <div className="flex items-start gap-3">
                <Phone className="w-5 h-5 text-white mt-1 flex-shrink-0" />
                <div className="text-sm">
                  <a href="tel:0561855552" className="text-white hover:text-gray-300 transition-colors">
                    0561855552
                  </a>
                </div>
              </div>
              <div className="flex items-start gap-3">
                <Mail className="w-5 h-5 text-white mt-1 flex-shrink-0" />
                <div className="text-sm">
                  <a href="mailto:Lawyer.mbs1@gmail.com" className="text-white hover:text-gray-300 transition-colors break-all">
                    Lawyer.mbs1@gmail.com
                  </a>
                </div>
              </div>
              <div className="flex items-start gap-3">
                <MapPin className="w-5 h-5 text-white mt-1 flex-shrink-0" />
                <div className="text-sm">
                  <p className="text-gray-300">{t('address')}</p>
                </div>
              </div>
            </div>
          </div>

          {/* Links */}
          <div>
            <h3 className="text-xl font-bold mb-4 text-white">{t('links')}</h3>
            <div className="space-y-2">
              <Link href={`/${locale}`} className="block text-gray-300 hover:text-white transition-colors text-sm">
                {t('links')}
              </Link>
              <Link href={`/${locale}#about`} className="block text-gray-300 hover:text-white transition-colors text-sm">
                من نحن
              </Link>
              <Link href={`/${locale}#services`} className="block text-gray-300 hover:text-white transition-colors text-sm">
                الخدمات
              </Link>
              <Link href={`/${locale}#team`} className="block text-gray-300 hover:text-white transition-colors text-sm">
                الفريق
              </Link>
            </div>
          </div>

          {/* Social */}
          <div>
            <h3 className="text-xl font-bold mb-4 text-white">{t('follow')}</h3>
            <div className="flex gap-4">
              <a
                href="https://twitter.com/lawyer_mbs"
                target="_blank"
                rel="noopener noreferrer"
                className="w-10 h-10 rounded-full bg-white/10 hover:bg-white/20 flex items-center justify-center transition-colors"
              >
                <Twitter className="w-5 h-5" />
              </a>
              <a
                href="https://instagram.com/lawyer_mbs"
                target="_blank"
                rel="noopener noreferrer"
                className="w-10 h-10 rounded-full bg-white/10 hover:bg-white/20 flex items-center justify-center transition-colors"
              >
                <Instagram className="w-5 h-5" />
              </a>
              <a
                href="https://linkedin.com"
                target="_blank"
                rel="noopener noreferrer"
                className="w-10 h-10 rounded-full bg-white/10 hover:bg-white/20 flex items-center justify-center transition-colors"
              >
                <Linkedin className="w-5 h-5" />
              </a>
            </div>
          </div>
        </div>

        <div className="border-t border-white/10 mt-8 pt-8 text-center text-sm text-gray-400">
          <p>&copy; {new Date().getFullYear()} مكتب المحامي محمد بن سليمان الحربي. جميع الحقوق محفوظة.</p>
        </div>
      </div>
    </footer>
  )
}
