'use client'

import { useState, useEffect } from 'react'
import Link from 'next/link'
import Image from 'next/image'
import { useTranslations, useLocale } from 'next-intl'
import { Menu, X, Globe } from 'lucide-react'
import { Button } from '@/components/ui/button'

export default function Header() {
  const [isMenuOpen, setIsMenuOpen] = useState(false)
  const [logoUrl, setLogoUrl] = useState('')
  const t = useTranslations('nav')
  const locale = useLocale()

  useEffect(() => {
    fetch('/api/settings')
      .then(res => res.json())
      .then(data => {
        if (data.logoUrl) {
          setLogoUrl(data.logoUrl)
        }
      })
      .catch(err => console.error(err))
  }, [])

  const toggleLocale = () => {
    const newLocale = locale === 'ar' ? 'en' : 'ar'
    window.location.href = `/${newLocale}`
  }

  return (
    <header className="fixed top-0 left-0 right-0 z-50 bg-white/95 backdrop-blur-sm shadow-sm">
      <div className="container mx-auto px-4">
        <div className="flex items-center justify-between h-20">
          {/* Logo */}
          <Link href={`/${locale}`} className="flex items-center">
            {logoUrl ? (
              <div className="relative w-32 h-16">
                <Image
                  src={logoUrl}
                  alt="Logo"
                  fill
                  className="object-contain"
                />
              </div>
            ) : (
              <div className="w-16 h-16 bg-gradient-to-br from-[#33335E] to-[#4a4d7c] rounded-lg flex items-center justify-center">
                <span className="text-white font-bold text-xl">MBS</span>
              </div>
            )}
          </Link>

          {/* Desktop Navigation */}
          <nav className="hidden md:flex items-center gap-8">
            <Link href={`/${locale}`} className="text-gray-700 hover:text-[#33335E] transition-colors font-medium">
              {t('home')}
            </Link>
            <Link href={`/${locale}#about`} className="text-gray-700 hover:text-[#33335E] transition-colors font-medium">
              {t('about')}
            </Link>
            <Link href={`/${locale}#services`} className="text-gray-700 hover:text-[#33335E] transition-colors font-medium">
              {t('services')}
            </Link>
            <Link href={`/${locale}#team`} className="text-gray-700 hover:text-[#33335E] transition-colors font-medium">
              {t('team')}
            </Link>
            <Link href={`/${locale}#contact`} className="text-gray-700 hover:text-[#33335E] transition-colors font-medium">
              {t('contact')}
            </Link>
            
            {/* Language Toggle */}
            <Button
              variant="outline"
              size="sm"
              onClick={toggleLocale}
              className="gap-2"
            >
              <Globe className="w-4 h-4" />
              {locale === 'ar' ? 'EN' : 'AR'}
            </Button>
          </nav>

          {/* Mobile Menu Button */}
          <button
            onClick={() => setIsMenuOpen(!isMenuOpen)}
            className="md:hidden p-2 text-gray-700 hover:text-[#33335E]"
          >
            {isMenuOpen ? <X className="w-6 h-6" /> : <Menu className="w-6 h-6" />}
          </button>
        </div>

        {/* Mobile Navigation */}
        {isMenuOpen && (
          <nav className="md:hidden py-4 border-t">
            <div className="flex flex-col gap-4">
              <Link
                href={`/${locale}`}
                className="text-gray-700 hover:text-[#33335E] transition-colors font-medium"
                onClick={() => setIsMenuOpen(false)}
              >
                {t('home')}
              </Link>
              <Link
                href={`/${locale}#about`}
                className="text-gray-700 hover:text-[#33335E] transition-colors font-medium"
                onClick={() => setIsMenuOpen(false)}
              >
                {t('about')}
              </Link>
              <Link
                href={`/${locale}#services`}
                className="text-gray-700 hover:text-[#33335E] transition-colors font-medium"
                onClick={() => setIsMenuOpen(false)}
              >
                {t('services')}
              </Link>
              <Link
                href={`/${locale}#team`}
                className="text-gray-700 hover:text-[#33335E] transition-colors font-medium"
                onClick={() => setIsMenuOpen(false)}
              >
                {t('team')}
              </Link>
              <Link
                href={`/${locale}#contact`}
                className="text-gray-700 hover:text-[#33335E] transition-colors font-medium"
                onClick={() => setIsMenuOpen(false)}
              >
                {t('contact')}
              </Link>
              <Button
                variant="outline"
                size="sm"
                onClick={toggleLocale}
                className="gap-2 w-fit"
              >
                <Globe className="w-4 h-4" />
                {locale === 'ar' ? 'English' : 'العربية'}
              </Button>
            </div>
          </nav>
        )}
      </div>
    </header>
  )
}
