'use client'

import { useTranslations, useLocale } from 'next-intl'
import { useState, useEffect } from 'react'

export default function AboutSection() {
  const t = useTranslations('about')
  const locale = useLocale()
  const [content, setContent] = useState({ aboutAr: '', aboutEn: '' })

  useEffect(() => {
    fetch('/api/content/about')
      .then(res => res.json())
      .then(data => setContent(data))
      .catch(err => console.error(err))
  }, [])

  return (
    <section id="about" className="py-20 bg-white relative overflow-hidden">
      {/* Background Pattern */}
      <div className="absolute inset-0 opacity-5">
        <div className="absolute top-0 left-0 w-96 h-96 bg-gray-200 rounded-full blur-3xl" />
      </div>

      <div className="container mx-auto px-4 relative z-10">
        <div className="max-w-4xl mx-auto text-right">
          <h2 className="text-4xl md:text-5xl font-bold mb-8 text-[#33335E]">
            {t('title')}
          </h2>
          <p className="text-base md:text-lg text-gray-700 leading-loose">
            {locale === 'ar' ? content.aboutAr : content.aboutEn || t('description')}
          </p>
        </div>
      </div>
    </section>
  )
}
