'use client'

import { useTranslations, useLocale } from 'next-intl'
import { ChevronLeft, ChevronRight } from 'lucide-react'
import { useState, useEffect } from 'react'
import Image from 'next/image'

export default function AccreditationsSection() {
  const t = useTranslations('accreditations')
  const locale = useLocale()
  const [currentIndex, setCurrentIndex] = useState(0)
  const [accreditations, setAccreditations] = useState<any[]>([])

  useEffect(() => {
    fetch('/api/accreditations')
      .then(res => res.json())
      .then(data => setAccreditations(data))
      .catch(err => console.error(err))
  }, [])

  const next = () => {
    if (accreditations.length > 0) {
      setCurrentIndex((prev) => (prev + 1) % accreditations.length)
    }
  }

  const prev = () => {
    if (accreditations.length > 0) {
      setCurrentIndex((prev) => (prev - 1 + accreditations.length) % accreditations.length)
    }
  }

  return (
    <section className="py-20 bg-[#33335E] text-white relative overflow-hidden">
      {/* Decorative Circles */}
      <div className="absolute top-0 left-0 w-64 h-64 border-2 border-white/10 rounded-full -translate-x-1/2 -translate-y-1/2" />
      <div className="absolute bottom-0 right-0 w-96 h-96 border-2 border-white/10 rounded-full translate-x-1/3 translate-y-1/3" />
      
      <div className="container mx-auto px-4 relative z-10">
        <h2 className="text-3xl md:text-4xl font-bold text-center mb-12">
          {t('title')}
        </h2>

        <div className="relative max-w-4xl mx-auto">
          <button
            onClick={prev}
            className="absolute left-0 top-1/2 -translate-y-1/2 z-10 flex items-center justify-center hover:opacity-80 transition-opacity"
          >
            <ChevronLeft className="w-8 h-8 text-white" />
          </button>

          <div className="flex items-center justify-center gap-8">
            {accreditations.slice(currentIndex, currentIndex + 3).map((item) => (
              <div
                key={item.id}
                className="w-56 h-40 bg-white rounded-2xl flex flex-col items-center justify-center p-6 hover:scale-105 transition-transform"
              >
                <div className="text-gray-400 text-center mb-2">
                  {item.logo ? (
                    <div className="relative w-20 h-20 mx-auto mb-2">
                      <Image src={item.logo} alt={item.nameAr} fill className="object-contain" />
                    </div>
                  ) : (
                    <div className="w-20 h-20 mx-auto bg-gray-100 rounded-lg flex items-center justify-center mb-2">
                      Logo
                    </div>
                  )}
                </div>
                <p className="text-[#33335E] text-sm font-medium">
                  {locale === 'ar' ? item.nameAr : item.nameEn}
                </p>
              </div>
            ))}
          </div>

          <button
            onClick={next}
            className="absolute right-0 top-1/2 -translate-y-1/2 z-10 flex items-center justify-center hover:opacity-80 transition-opacity"
          >
            <ChevronRight className="w-8 h-8 text-white" />
          </button>
        </div>
      </div>
    </section>
  )
}
