'use client'

import { useTranslations, useLocale } from 'next-intl'
import { useState, useEffect } from 'react'
import { FileText, Handshake, Lightbulb } from 'lucide-react'

export default function PrinciplesSection() {
  const t = useTranslations('principles')
  const locale = useLocale()
  const [content, setContent] = useState({ transparencyAr: '', transparencyEn: '', commitmentAr: '', commitmentEn: '', innovationAr: '', innovationEn: '' })

  useEffect(() => {
    fetch('/api/content/principles')
      .then(res => res.json())
      .then(data => setContent(data))
      .catch(err => console.error(err))
  }, [])

  const principles = [
    {
      icon: Lightbulb,
      title: t('innovation.title'),
      description: locale === 'ar' ? content.innovationAr : content.innovationEn || t('innovation.description'),
    },
    {
      icon: Handshake,
      title: t('commitment.title'),
      description: locale === 'ar' ? content.commitmentAr : content.commitmentEn || t('commitment.description'),
    },
    {
      icon: FileText,
      title: t('transparency.title'),
      description: locale === 'ar' ? content.transparencyAr : content.transparencyEn || t('transparency.description'),
    },
  ]

  return (
    <section className="py-20 bg-gray-50">
      <div className="container mx-auto px-4">
        <div className="grid grid-cols-1 md:grid-cols-3 gap-8">
          {principles.map((principle, index) => (
            <div key={index} className="bg-white rounded-3xl border-2 border-gray-200 p-8 text-center hover:shadow-xl transition-shadow">
              <div className="w-24 h-24 rounded-full border-2 border-[#33335E] flex items-center justify-center mx-auto mb-6">
                <principle.icon className="w-12 h-12 text-[#33335E]" />
              </div>
              <div className="bg-[#33335E] text-white px-8 py-2 rounded-lg inline-block mb-4">
                <h3 className="text-base font-bold whitespace-nowrap">
                  {principle.title}
                </h3>
              </div>
              <p className="text-gray-700 leading-relaxed text-sm px-2">
                {principle.description}
              </p>
            </div>
          ))}
        </div>
      </div>
    </section>
  )
}
