'use client'

import { useEffect, useState } from 'react'
import { useTranslations, useLocale } from 'next-intl'
import { Scale, Gavel, FileText, FileCheck, Handshake, Building } from 'lucide-react'
import { Card } from '@/components/ui/card'
import Image from 'next/image'

const iconMap: Record<string, any> = {
  scale: Scale,
  gavel: Gavel,
  'file-text': FileText,
  'file-check': FileCheck,
  handshake: Handshake,
  building: Building,
}

export default function ServicesSection() {
  const t = useTranslations('services')
  const locale = useLocale()
  const [services, setServices] = useState<any[]>([])

  useEffect(() => {
    fetch('/api/services')
      .then(res => res.json())
      .then(data => setServices(data))
      .catch(err => console.error(err))
  }, [])

  return (
    <section id="services" className="py-20 bg-white">
      <div className="container mx-auto px-4">
        <div className="text-center mb-12">
          <h2 className="text-4xl md:text-5xl font-bold mb-4 text-[#33335E]">
            {t('title')}
          </h2>
          <p className="text-sm text-gray-600 max-w-3xl mx-auto">
            {t('subtitle')}
          </p>
        </div>

        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6 max-w-5xl mx-auto">
          {services.map((service) => {
            const Icon = iconMap[service.icon] || Scale
            return (
              <div
                key={service.id}
                className="p-8 bg-[#2B2C4F] text-white rounded-3xl border-2 border-[#2B2C4F] hover:shadow-xl transition-all duration-300"
              >
                <div className="flex flex-col items-center text-center space-y-4">
                  {service.image ? (
                    <div className="relative w-20 h-20 rounded-lg overflow-hidden">
                      <Image src={service.image} alt={service.titleAr} fill className="object-cover" />
                    </div>
                  ) : (
                    <div className="mb-4">
                      <Icon className="w-12 h-12 text-white" />
                    </div>
                  )}
                  <h3 className="text-lg font-bold">
                    {locale === 'ar' ? service.titleAr : service.titleEn}
                  </h3>
                  <p className="text-sm text-gray-200">
                    {locale === 'ar' ? service.descriptionAr : service.descriptionEn}
                  </p>
                </div>
              </div>
            )
          })}
        </div>
      </div>
    </section>
  )
}
