'use client'

import { useTranslations, useLocale } from 'next-intl'
import { useState, useEffect } from 'react'
import { User } from 'lucide-react'
import Image from 'next/image'

export default function TeamSection() {
  const t = useTranslations('team')
  const locale = useLocale()
  const [team, setTeam] = useState<any[]>([])

  useEffect(() => {
    fetch('/api/team')
      .then(res => res.json())
      .then(data => setTeam(data))
      .catch(err => console.error(err))
  }, [])

  return (
    <section id="team" className="py-20 bg-gray-50">
      <div className="container mx-auto px-4">
        <h2 className="text-4xl md:text-5xl font-bold text-center mb-16 text-[#33335E]">
          {t('title')}
        </h2>

        <div className="flex items-start justify-center gap-12 flex-wrap max-w-5xl mx-auto">
          {team.map((member) => (
            <div key={member.id} className="text-center">
              <div className="w-36 h-36 rounded-full border-2 border-[#33335E] mb-4 mx-auto bg-white overflow-hidden relative flex items-center justify-center p-3">
                {member.image ? (
                  <div className="relative w-24 h-24 rounded-full overflow-hidden">
                    <Image 
                      src={member.image} 
                      alt={member.nameAr} 
                      fill 
                      className="object-cover"
                      unoptimized
                    />
                  </div>
                ) : (
                  <div className="w-full h-full flex items-center justify-center">
                    <User className="w-20 h-20 text-[#33335E]" />
                  </div>
                )}
              </div>
              <h3 className="font-bold text-base text-[#33335E] mb-1">
                {locale === 'ar' ? member.nameAr : member.nameEn}
              </h3>
              <p className="text-gray-600 text-sm">
                {locale === 'ar' ? member.positionAr : member.positionEn}
              </p>
            </div>
          ))}
        </div>
      </div>
    </section>
  )
}
