'use client'

import { useTranslations, useLocale } from 'next-intl'
import { useState, useEffect } from 'react'
import { Eye, Target, Scale } from 'lucide-react'
import { Card } from '@/components/ui/card'
import Image from 'next/image'

export default function ValuesSection() {
  const t = useTranslations('values')
  const locale = useLocale()
  const [content, setContent] = useState({ visionAr: '', visionEn: '', missionAr: '', missionEn: '', valuesAr: '', valuesEn: '', valuesImage: '' })

  useEffect(() => {
    fetch('/api/content/about')
      .then(res => res.json())
      .then(data => setContent(data))
      .catch(err => console.error(err))
  }, [])

  const values = [
    {
      icon: Eye,
      title: t('vision.title'),
      description: locale === 'ar' ? content.visionAr : content.visionEn || t('vision.description'),
    },
    {
      icon: Target,
      title: t('mission.title'),
      description: locale === 'ar' ? content.missionAr : content.missionEn || t('mission.description'),
    },
    {
      icon: Scale,
      title: t('values.title'),
      description: locale === 'ar' ? content.valuesAr : content.valuesEn || t('values.description'),
    },
  ]

  return (
    <section className="py-20 bg-gray-50">
      <div className="container mx-auto px-4">
        <div className="grid grid-cols-1 md:grid-cols-2 gap-12 items-center max-w-6xl mx-auto">
          {/* Values - Right Side */}
          <div className="space-y-8 order-2 md:order-1">
            {values.map((value, index) => (
              <div key={index} className="flex items-start gap-4">
                <div className="w-16 h-16 rounded-full bg-[#33335E] flex items-center justify-center flex-shrink-0">
                  <value.icon className="w-8 h-8 text-white" />
                </div>
                <div className="text-right flex-1">
                  <h3 className="text-xl font-bold text-[#33335E] mb-2">
                    {value.title}
                  </h3>
                  <p className="text-gray-700 leading-relaxed">
                    {value.description}
                  </p>
                </div>
              </div>
            ))}
          </div>

          {/* Image - Left Side */}
          <div className="relative order-1 md:order-2">
            {content.valuesImage ? (
              <div className="relative w-full aspect-square rounded-3xl overflow-hidden">
                <Image src={content.valuesImage} alt="Values" fill className="object-cover" />
              </div>
            ) : (
              <div className="aspect-square rounded-3xl bg-gradient-to-br from-[#33335E] to-[#4a4d7c] p-8 flex items-center justify-center">
                <div className="w-full h-full rounded-2xl flex items-center justify-center">
                  <Scale className="w-48 h-48 text-white" />
                </div>
              </div>
            )}
          </div>
        </div>
      </div>
    </section>
  )
}
