// Manual additions to make the generated types below work.

import type { TurbopackResult } from './types'

export type TurboTasks = { readonly __tag: unique symbol }
export type ExternalEndpoint = { readonly __tag: unique symbol }
export type NextTurboTasks = { readonly __tag: unique symbol }
export type RefCell = { readonly __tag: unique symbol }
export type NapiRouteHas = {
  type: string
  key?: string
  value?: string
  readonly __tag: unique symbol
}
export type RcStr = string

export function lightningCssTransform(args: object): Promise<unknown>
export function lightningCssTransformStyleAttribute(
  args: object
): Promise<unknown>

// GENERATED-TYPES-BELOW
// DO NOT MANUALLY EDIT THESE TYPES
// You can regenerate this file by running `pnpm swc-build-native` in the root of the repo.

/* tslint:disable */
/* eslint-disable */

/* auto-generated by NAPI-RS */

export declare class ExternalObject<T> {
  readonly '': {
    readonly '': unique symbol
    [K: symbol]: T
  }
}
export declare function lockfileTryAcquireSync(
  path: string
): { __napiType: 'Lockfile' } | null
export declare function lockfileTryAcquire(
  path: string
): Promise<{ __napiType: 'Lockfile' } | null>
export declare function lockfileUnlockSync(lockfile: {
  __napiType: 'Lockfile'
}): void
export declare function lockfileUnlock(lockfile: {
  __napiType: 'Lockfile'
}): Promise<void>
export declare function mdxCompile(
  value: string,
  option: Buffer,
  signal?: AbortSignal | undefined | null
): Promise<unknown>
export declare function mdxCompileSync(value: string, option: Buffer): string
export interface TransformOutput {
  code: string
  map?: string
  output?: string
  diagnostics: Array<string>
}
export declare function minify(
  input: Buffer,
  opts: Buffer,
  signal?: AbortSignal | undefined | null
): Promise<TransformOutput>
export declare function minifySync(input: Buffer, opts: Buffer): TransformOutput
export interface NapiEndpointConfig {}
export interface NapiServerPath {
  path: string
  contentHash: string
}
export interface NapiWrittenEndpoint {
  type: string
  entryPath?: string
  clientPaths: Array<string>
  serverPaths: Array<NapiServerPath>
  config: NapiEndpointConfig
}
export declare function endpointWriteToDisk(endpoint: {
  __napiType: 'Endpoint'
}): Promise<TurbopackResult>
export declare function endpointServerChangedSubscribe(
  endpoint: { __napiType: 'Endpoint' },
  issues: boolean,
  func: (...args: any[]) => any
): { __napiType: 'RootTask' }
export declare function endpointClientChangedSubscribe(
  endpoint: { __napiType: 'Endpoint' },
  func: (...args: any[]) => any
): { __napiType: 'RootTask' }
export interface NapiEnvVar {
  name: RcStr
  value: RcStr
}
export interface NapiOptionEnvVar {
  name: RcStr
  value?: RcStr
}
export interface NapiDraftModeOptions {
  previewModeId: RcStr
  previewModeEncryptionKey: RcStr
  previewModeSigningKey: RcStr
}
export interface NapiWatchOptions {
  /** Whether to watch the filesystem for file changes. */
  enable: boolean
  /**
   * Enable polling at a certain interval if the native file watching doesn't work (e.g.
   * docker).
   */
  pollIntervalMs?: number
}
export interface NapiProjectOptions {
  /**
   * An absolute root path (Unix or Windows path) from which all files must be nested under.
   * Trying to access a file outside this root will fail, so think of this as a chroot.
   * E.g. `/home/user/projects/my-repo`.
   */
  rootPath: RcStr
  /**
   * A path which contains the app/pages directories, relative to [`Project::root_path`], always
   * Unix path. E.g. `apps/my-app`
   */
  projectPath: RcStr
  /**
   * A path where tracing output will be written to and/or cache is read/written.
   * Usually equal to the `distDir` in next.config.js.
   * E.g. `.next`
   */
  distDir: RcStr
  /** Filesystem watcher options. */
  watch: NapiWatchOptions
  /** The contents of next.config.js, serialized to JSON. */
  nextConfig: RcStr
  /** A map of environment variables to use when compiling code. */
  env: Array<NapiEnvVar>
  /**
   * A map of environment variables which should get injected at compile
   * time.
   */
  defineEnv: NapiDefineEnv
  /** The mode in which Next.js is running. */
  dev: boolean
  /** The server actions encryption key. */
  encryptionKey: RcStr
  /** The build id. */
  buildId: RcStr
  /** Options for draft mode. */
  previewProps: NapiDraftModeOptions
  /** The browserslist query to use for targeting browsers. */
  browserslistQuery: RcStr
  /**
   * When the code is minified, this opts out of the default mangling of
   * local names for variables, functions etc., which can be useful for
   * debugging/profiling purposes.
   */
  noMangling: boolean
  /** The version of Node.js that is available/currently running. */
  currentNodeJsVersion: RcStr
}
/** [NapiProjectOptions] with all fields optional. */
export interface NapiPartialProjectOptions {
  /**
   * An absolute root path  (Unix or Windows path) from which all files must be nested under.
   * Trying to access a file outside this root will fail, so think of this as a chroot.
   * E.g. `/home/user/projects/my-repo`.
   */
  rootPath?: RcStr
  /**
   * A path which contains the app/pages directories, relative to [`Project::root_path`], always
   * a Unix path.
   * E.g. `apps/my-app`
   */
  projectPath?: RcStr
  /** Filesystem watcher options. */
  watch?: NapiWatchOptions
  /** The contents of next.config.js, serialized to JSON. */
  nextConfig?: RcStr
  /** A map of environment variables to use when compiling code. */
  env?: Array<NapiEnvVar>
  /**
   * A map of environment variables which should get injected at compile
   * time.
   */
  defineEnv?: NapiDefineEnv
  /** The mode in which Next.js is running. */
  dev?: boolean
  /** The server actions encryption key. */
  encryptionKey?: RcStr
  /** The build id. */
  buildId?: RcStr
  /** Options for draft mode. */
  previewProps?: NapiDraftModeOptions
  /** The browserslist query to use for targeting browsers. */
  browserslistQuery?: RcStr
  /**
   * When the code is minified, this opts out of the default mangling of
   * local names for variables, functions etc., which can be useful for
   * debugging/profiling purposes.
   */
  noMangling?: boolean
}
export interface NapiDefineEnv {
  client: Array<NapiOptionEnvVar>
  edge: Array<NapiOptionEnvVar>
  nodejs: Array<NapiOptionEnvVar>
}
export interface NapiTurboEngineOptions {
  /** Use the new backend with filesystem cache enabled. */
  persistentCaching?: boolean
  /** An upper bound of memory that turbopack will attempt to stay under. */
  memoryLimit?: number
  /** Track dependencies between tasks. If false, any change during build will error. */
  dependencyTracking?: boolean
  /** Whether the project is running in a CI environment. */
  isCi?: boolean
  /** Whether the project is running in a short session. */
  isShortSession?: boolean
}
export declare function projectNew(
  options: NapiProjectOptions,
  turboEngineOptions: NapiTurboEngineOptions,
  napiCallbacks: NapiNextTurbopackCallbacksJsObject
): Promise<{ __napiType: 'Project' }>
export declare function projectUpdate(
  project: { __napiType: 'Project' },
  options: NapiPartialProjectOptions
): Promise<void>
/**
 * Invalidates the filesystem cache so that it will be deleted next time that a turbopack project
 * is created with filesystem cache enabled.
 */
export declare function projectInvalidateFileSystemCache(project: {
  __napiType: 'Project'
}): Promise<void>
/**
 * Runs exit handlers for the project registered using the [`ExitHandler`] API.
 *
 * This is called by `project_shutdown`, so if you're calling that API, you shouldn't call this
 * one.
 */
export declare function projectOnExit(project: {
  __napiType: 'Project'
}): Promise<void>
/**
 * Runs `project_on_exit`, and then waits for turbo_tasks to gracefully shut down.
 *
 * This is used in builds where it's important that we completely persist turbo-tasks to disk, but
 * it's skipped in the development server (`project_on_exit` is used instead with a short timeout),
 * where we prioritize fast exit and user responsiveness over all else.
 */
export declare function projectShutdown(project: {
  __napiType: 'Project'
}): Promise<void>
export interface AppPageNapiRoute {
  /** The relative path from project_path to the route file */
  originalName?: RcStr
  htmlEndpoint?: ExternalObject<ExternalEndpoint>
  rscEndpoint?: ExternalObject<ExternalEndpoint>
}
export interface NapiRoute {
  /** The router path */
  pathname: string
  /** The relative path from project_path to the route file */
  originalName?: RcStr
  /** The type of route, eg a Page or App */
  type: string
  pages?: Array<AppPageNapiRoute>
  endpoint?: ExternalObject<ExternalEndpoint>
  htmlEndpoint?: ExternalObject<ExternalEndpoint>
  rscEndpoint?: ExternalObject<ExternalEndpoint>
  dataEndpoint?: ExternalObject<ExternalEndpoint>
}
export interface NapiMiddleware {
  endpoint: ExternalObject<ExternalEndpoint>
  isProxy: boolean
}
export interface NapiInstrumentation {
  nodeJs: ExternalObject<ExternalEndpoint>
  edge: ExternalObject<ExternalEndpoint>
}
export interface NapiEntrypoints {
  routes: Array<NapiRoute>
  middleware?: NapiMiddleware
  instrumentation?: NapiInstrumentation
  pagesDocumentEndpoint: ExternalObject<ExternalEndpoint>
  pagesAppEndpoint: ExternalObject<ExternalEndpoint>
  pagesErrorEndpoint: ExternalObject<ExternalEndpoint>
}
export declare function projectWriteAllEntrypointsToDisk(
  project: { __napiType: 'Project' },
  appDirOnly: boolean
): Promise<TurbopackResult>
export declare function projectEntrypoints(project: {
  __napiType: 'Project'
}): Promise<TurbopackResult>
export declare function projectEntrypointsSubscribe(
  project: { __napiType: 'Project' },
  func: (...args: any[]) => any
): { __napiType: 'RootTask' }
export declare function projectHmrEvents(
  project: { __napiType: 'Project' },
  identifier: RcStr,
  func: (...args: any[]) => any
): { __napiType: 'RootTask' }
export interface HmrIdentifiers {
  identifiers: Array<RcStr>
}
export declare function projectHmrIdentifiersSubscribe(
  project: { __napiType: 'Project' },
  func: (...args: any[]) => any
): { __napiType: 'RootTask' }
export interface NapiUpdateMessage {
  updateType: string
  value?: NapiUpdateInfo
}
export interface NapiUpdateInfo {
  duration: number
  tasks: number
}
/**
 * Subscribes to lifecycle events of the compilation.
 *
 * Emits an [UpdateMessage::Start] event when any computation starts.
 * Emits an [UpdateMessage::End] event when there was no computation for the
 * specified time (`aggregation_ms`). The [UpdateMessage::End] event contains
 * information about the computations that happened since the
 * [UpdateMessage::Start] event. It contains the duration of the computation
 * (excluding the idle time that was spend waiting for `aggregation_ms`), and
 * the number of tasks that were executed.
 *
 * The signature of the `func` is `(update_message: UpdateMessage) => void`.
 */
export declare function projectUpdateInfoSubscribe(
  project: { __napiType: 'Project' },
  aggregationMs: number,
  func: (...args: any[]) => any
): void
/** Subscribes to all compilation events that are not cached like timing and progress information. */
export declare function projectCompilationEventsSubscribe(
  project: { __napiType: 'Project' },
  func: (...args: any[]) => any,
  eventTypes?: Array<string> | undefined | null
): void
export interface StackFrame {
  isServer: boolean
  isInternal?: boolean
  originalFile?: RcStr
  file: RcStr
  /** 1-indexed, unlike source map tokens */
  line?: number
  /** 1-indexed, unlike source map tokens */
  column?: number
  methodName?: RcStr
}
export declare function projectTraceSource(
  project: { __napiType: 'Project' },
  frame: StackFrame,
  currentDirectoryFileUrl: string
): Promise<StackFrame | null>
export declare function projectGetSourceForAsset(
  project: { __napiType: 'Project' },
  filePath: RcStr
): Promise<string | null>
export declare function projectGetSourceMap(
  project: { __napiType: 'Project' },
  filePath: RcStr
): Promise<string | null>
export declare function projectGetSourceMapSync(
  project: { __napiType: 'Project' },
  filePath: RcStr
): string | null
export declare function projectWriteAnalyzeData(
  project: { __napiType: 'Project' },
  appDirOnly: boolean
): Promise<TurbopackResult>
/**
 * A version of [`NapiNextTurbopackCallbacks`] that can accepted as an argument to a napi function.
 *
 * This can be converted into a [`NapiNextTurbopackCallbacks`] with
 * [`NapiNextTurbopackCallbacks::from_js`].
 */
export interface NapiNextTurbopackCallbacksJsObject {
  /**
   * Called when we've encountered a bug in Turbopack and not in the user's code. Constructs and
   * throws a `TurbopackInternalError` type. Logs to anonymized telemetry.
   *
   * As a result of the use of `ErrorStrategy::CalleeHandled`, the first argument is an error if
   * there's a runtime conversion error. This should never happen, but if it does, the function
   * can throw it instead.
   */
  throwTurbopackInternalError: (
    conversionError: Error | null,
    opts: TurbopackInternalErrorOpts
  ) => never
}
/** Arguments for [`NapiNextTurbopackCallbacks::throw_turbopack_internal_error`]. */
export interface TurbopackInternalErrorOpts {
  message: string
  anonymizedLocation?: string
}
export declare function rootTaskDispose(rootTask: {
  __napiType: 'RootTask'
}): void
export interface NapiIssue {
  severity: string
  stage: string
  filePath: string
  title: any
  description?: any
  detail?: any
  source?: NapiIssueSource
  documentationLink: string
  importTraces: any
}
export interface NapiIssueSource {
  source: NapiSource
  range?: NapiIssueSourceRange
}
export interface NapiIssueSourceRange {
  start: NapiSourcePos
  end: NapiSourcePos
}
export interface NapiSource {
  ident: string
  content?: string
}
export interface NapiSourcePos {
  line: number
  column: number
}
export interface NapiDiagnostic {
  category: string
  name: string
  payload: Record<string, string>
}
export declare function expandNextJsTemplate(
  content: Buffer,
  templatePath: string,
  nextPackageDirPath: string,
  replacements: Record<string, string>,
  injections: Record<string, string>,
  imports: Record<string, string | null>
): string
export declare function parse(
  src: string,
  options: Buffer,
  filename?: string | undefined | null,
  signal?: AbortSignal | undefined | null
): Promise<string>
export declare function isReactCompilerRequired(
  filename: string,
  signal?: AbortSignal | undefined | null
): Promise<boolean>
export declare function getModuleNamedExports(
  resourcePath: string
): Promise<string[]>
export interface NapiSourceDiagnostic {
  severity: string
  message: string
  loc: NapiIssueSourceRange
}
export declare function warnForEdgeRuntime(
  source: string,
  isProduction: boolean
): Promise<NapiSourceDiagnostic[]>
export declare function transform(
  src: string | Buffer | undefined,
  isModule: boolean,
  options: Buffer,
  signal?: AbortSignal | undefined | null
): Promise<unknown>
export declare function transformSync(
  src: string | Buffer | undefined,
  isModule: boolean,
  options: Buffer
): object
export declare function startTurbopackTraceServer(
  path: string,
  port?: number | undefined | null
): void
export interface NextBuildContext {
  /** The root directory of the workspace. */
  root?: string
  /** The project's directory. */
  dir?: string
  /**
   * next.config.js's distDir. Current there's some early stage setup
   * requires this Before construct a context to read next.config.js,
   * which we passes separately here.
   */
  distDir?: string
  /** The build ID. */
  buildId?: string
  /** The rewrites, as computed by Next.js. */
  rewrites?: NapiRewrites
  defineEnv: NapiDefineEnv
}
/** Keep in sync with [`next_core::next_config::Rewrites`] */
export interface NapiRewrites {
  fallback: Array<NapiRewrite>
  afterFiles: Array<NapiRewrite>
  beforeFiles: Array<NapiRewrite>
}
/** Keep in sync with [`next_core::next_config::Rewrite`] */
export interface NapiRewrite {
  source: string
  destination: string
  basePath?: boolean
  locale?: boolean
  has?: Array<NapiRouteHas>
  missing?: Array<NapiRouteHas>
}
export declare function getTargetTriple(): string
/**
 * Initialize tracing subscriber to emit traces. This configures subscribers
 * for Trace Event Format <https://docs.google.com/document/d/1CvAClvFfyA5R-PhYUmn5OOQtYMH4h6I0nSsKchNAySU/preview>.
 */
export declare function initCustomTraceSubscriber(
  traceOutFilePath?: string | undefined | null
): ExternalObject<RefCell>
/**
 * Teardown currently running tracing subscriber to flush out remaining traces.
 * This should be called when parent node.js process exits, otherwise generated
 * trace may drop traces in the buffer.
 */
export declare function teardownTraceSubscriber(
  guardExternal: ExternalObject<RefCell>
): void
