import { PrismaClient } from '@prisma/client'
import bcrypt from 'bcryptjs'

const prisma = new PrismaClient()

async function main() {
  const hashedPassword = await bcrypt.hash('admin123', 10)
  
  const admin = await prisma.user.upsert({
    where: { username: 'admin' },
    update: {},
    create: {
      username: 'admin',
      password: hashedPassword,
    },
  })

  console.log('✅ Admin user created:', admin.username)

  const services = [
    {
      titleAr: 'الاستشارات والدراسات القانونية',
      titleEn: 'Legal Consultations and Studies',
      descriptionAr: 'نقدم استشارات قانونية متخصصة ودراسات قانونية شاملة',
      descriptionEn: 'We provide specialized legal consultations and comprehensive legal studies',
      icon: 'scale',
      order: 1,
    },
    {
      titleAr: 'التقاضي والنزاع',
      titleEn: 'Litigation and Disputes',
      descriptionAr: 'تمثيل قانوني احترافي في جميع المحاكم والهيئات القضائية',
      descriptionEn: 'Professional legal representation in all courts and judicial bodies',
      icon: 'gavel',
      order: 2,
    },
    {
      titleAr: 'صياغة ومراجعة العقود والصفقات التجارية',
      titleEn: 'Drafting and Reviewing Contracts',
      descriptionAr: 'صياغة ومراجعة العقود التجارية والاتفاقيات القانونية',
      descriptionEn: 'Drafting and reviewing commercial contracts and legal agreements',
      icon: 'file-text',
      order: 3,
    },
    {
      titleAr: 'التوثيق',
      titleEn: 'Documentation',
      descriptionAr: 'خدمات توثيق المستندات والعقود الرسمية',
      descriptionEn: 'Documentation services for official documents and contracts',
      icon: 'file-check',
      order: 4,
    },
    {
      titleAr: 'الوساطة والتحكيم',
      titleEn: 'Mediation and Arbitration',
      descriptionAr: 'حل النزاعات عبر الوساطة والتحكيم',
      descriptionEn: 'Dispute resolution through mediation and arbitration',
      icon: 'handshake',
      order: 5,
    },
    {
      titleAr: 'حوكمة الشركات',
      titleEn: 'Corporate Governance',
      descriptionAr: 'استشارات حوكمة الشركات والامتثال القانوني',
      descriptionEn: 'Corporate governance and legal compliance consultations',
      icon: 'building',
      order: 6,
    },
  ]

  for (const service of services) {
    await prisma.service.upsert({
      where: { id: service.titleEn },
      update: service,
      create: { ...service, id: service.titleEn },
    })
  }

  console.log('✅ Services created')

  const content = [
    {
      key: 'hero_title_ar',
      valueAr: 'الخبرة القانونية لنجاح أعمالكم',
      valueEn: 'Legal Expertise for Your Business Success',
    },
    {
      key: 'hero_subtitle_ar',
      valueAr: 'مكتب محاماة متخصص في تقديم الحلول القانونية المتكاملة',
      valueEn: 'A law firm specialized in providing integrated legal solutions',
    },
    {
      key: 'about_title_ar',
      valueAr: 'من نحن',
      valueEn: 'About Us',
    },
    {
      key: 'about_text_ar',
      valueAr: 'يعد مكتب المحامي والموثق/ محمد بن سليمان الحربي من المكاتب الرائدة في مجال تقديم الخدمات القانونية في منطقة المدينة المنورة. والذي يكرس جهوده في تلبية احتياجات عملائه من الأفراد والشركات من خلال تقديم حلول قانونية تحمي وتحافظ على حقوقهم. وتؤدي الى متانة مراكزهم القانونية. كما يضم المكتب نخبة من الكوادر القانونية المؤهلة ذوي الخبرة الواسعة في مختلف المجالات القانونية في المملكة العربية السعودية',
      valueEn: 'The office of Lawyer and Notary Mohammed bin Sulaiman Al-Harbi is one of the leading offices in providing legal services in the Madinah region. The office dedicates its efforts to meeting the needs of its clients, individuals and companies, by providing legal solutions that protect and preserve their rights and lead to the strength of their legal positions. The office also includes a select group of qualified legal cadres with extensive experience in various legal fields in the Kingdom of Saudi Arabia',
    },
  ]

  for (const item of content) {
    await prisma.content.upsert({
      where: { key: item.key },
      update: item,
      create: item,
    })
  }

  console.log('✅ Content created')
}

main()
  .catch((e) => {
    console.error(e)
    process.exit(1)
  })
  .finally(async () => {
    await prisma.$disconnect()
  })
